/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.roles;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.Client;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.select.GuiSoundSelection;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobBard;

public class GuiNpcBard
extends GuiNPCInterface2
implements ISubGuiListener,
ITextfieldListener {
    private final JobBard job;

    public GuiNpcBard(EntityNPCInterface npc) {
        super(npc);
        this.job = (JobBard)npc.advanced.jobInterface;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                MusicController.Instance.stopSound("", SoundCategory.MUSIC);
                MusicController.Instance.stopSound("", SoundCategory.AMBIENT);
                this.setSubGui(new GuiSoundSelection(this.job.song));
                break;
            }
            case 1: {
                this.job.song = "";
                this.getTextField(1).setFullText("");
                MusicController.Instance.stopSound("", SoundCategory.MUSIC);
                MusicController.Instance.stopSound("", SoundCategory.AMBIENT);
                break;
            }
            case 2: {
                this.job.isStreamer = button.getValue() == 0;
                this.func_73866_w_();
                break;
            }
            case 3: {
                this.job.hasOffRange = button.getValue() == 0;
                this.func_73866_w_();
                break;
            }
            case 4: {
                this.job.isRange = button.getValue() == 0;
                this.func_73866_w_();
            }
        }
    }

    @Override
    public void func_73866_w_() {
        int i;
        super.func_73866_w_();
        int x = 56;
        int y = 50;
        GuiNpcTextField textField = new GuiNpcTextField(1, this, this.field_146289_q, this.guiLeft + x, this.guiTop + y, 200, 20, this.job.song);
        textField.setHoverText("bard.hover.song", new Object[0]);
        this.addTextField(textField);
        GuiNpcButton button = new GuiNpcButton(0, this.guiLeft + x + 205, this.guiTop + y, 80, 20, "gui.selectSound");
        button.setHoverText("bard.hover.select", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(1, this.guiLeft + x + 289, this.guiTop + y, 20, 20, "X");
        button.setHoverText("bard.hover.del", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(2, this.guiLeft + x - 25, this.guiTop + (y += 30), 120, 20, new String[]{"bard.jukebox", "bard.background"}, this.job.isStreamer ? 0 : 1);
        button.setHoverText(new TextComponentTranslation("bard.hover.range." + (this.job.isStreamer ? 0 : 1), new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("bard.hover.range.2", new Object[0])).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(3, this.guiLeft + x + 97, this.guiTop + y, 120, 20, new String[]{"bard.hasoff", "bard.hason"}, this.job.hasOffRange ? 0 : 1);
        button.setHoverText("bard.hover.dist." + (this.job.hasOffRange ? 0 : 1), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(4, this.guiLeft + x + 219, this.guiTop + y, 120, 20, new String[]{"type.range", "parameter.position"}, this.job.isRange ? 0 : 1);
        button.setHoverText("bard.hover.type." + this.job.isRange, new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(0, "bard.ondistance", this.guiLeft + x, this.guiTop + (y += 30) + 6));
        for (i = 0; i < 3; ++i) {
            textField = new GuiNpcTextField(2 + i, this, this.field_146289_q, this.guiLeft + x + 104 + i * 44, this.guiTop + y, 40, 20, "");
            textField.setMinMaxDefault(2L, 64L, 5L);
            if (this.job.isRange && i == 0) {
                textField.func_146180_a(this.job.range[0] + "");
                textField.setHoverText("bard.hover.min", new Object[0]);
            } else {
                textField.func_146180_a(this.job.minPos[i] + "");
                boolean bl = textField.enabled = !this.job.isRange;
                if (i == 0) {
                    textField.setHoverText(new TextComponentTranslation("bard.hover.min", new Object[0]).func_150257_a((ITextComponent)new TextComponentString("<br>")).func_150257_a((ITextComponent)new TextComponentTranslation("hover.scale.x", new Object[0])).func_150254_d(), new Object[0]);
                } else if (i == 1) {
                    textField.setHoverText(new TextComponentTranslation("bard.hover.min", new Object[0]).func_150257_a((ITextComponent)new TextComponentString("<br>")).func_150257_a((ITextComponent)new TextComponentTranslation("hover.scale.y", new Object[0])).func_150254_d(), new Object[0]);
                } else {
                    textField.setHoverText(new TextComponentTranslation("bard.hover.min", new Object[0]).func_150257_a((ITextComponent)new TextComponentString("<br>")).func_150257_a((ITextComponent)new TextComponentTranslation("hover.scale.z", new Object[0])).func_150254_d(), new Object[0]);
                }
            }
            this.addTextField(textField);
        }
        this.addLabel(new GuiNpcLabel(1, "bard.offdistance", this.guiLeft + x, this.guiTop + (y += 30) + 6));
        this.getLabel(1).setEnabled(this.job.hasOffRange);
        if (this.job.hasOffRange) {
            for (i = 0; i < 3; ++i) {
                textField = new GuiNpcTextField(5 + i, this, this.field_146289_q, this.guiLeft + x + 104 + i * 44, this.guiTop + y, 40, 20, "");
                textField.setMinMaxDefault(2L, 256L, 64L);
                if (this.job.isRange && i == 0) {
                    textField.func_146180_a(this.job.range[1] + "");
                    textField.setHoverText(new TextComponentTranslation("bard.hover.max", new Object[0]).func_150254_d(), new Object[0]);
                } else {
                    textField.func_146180_a(this.job.maxPos[i] + "");
                    boolean bl = textField.enabled = !this.job.isRange;
                    if (i == 0) {
                        textField.setHoverText(new TextComponentTranslation("bard.hover.max", new Object[0]).func_150257_a((ITextComponent)new TextComponentString("<br>")).func_150257_a((ITextComponent)new TextComponentTranslation("hover.scale.x", new Object[0])).func_150254_d(), new Object[0]);
                    } else if (i == 1) {
                        textField.setHoverText(new TextComponentTranslation("bard.hover.max", new Object[0]).func_150257_a((ITextComponent)new TextComponentString("<br>")).func_150257_a((ITextComponent)new TextComponentTranslation("hover.scale.y", new Object[0])).func_150254_d(), new Object[0]);
                    } else {
                        textField.setHoverText(new TextComponentTranslation("bard.hover.max", new Object[0]).func_150257_a((ITextComponent)new TextComponentString("<br>")).func_150257_a((ITextComponent)new TextComponentTranslation("hover.scale.z", new Object[0])).func_150254_d(), new Object[0]);
                    }
                }
                this.addTextField(textField);
            }
        }
    }

    @Override
    public void func_73869_a(char c, int i) {
        super.func_73869_a(c, i);
        if (i == 1) {
            this.save();
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuAdvanced);
        }
    }

    @Override
    public void save() {
        if (this.job.range[0] > this.job.range[1]) {
            this.job.range[1] = this.job.range[0];
        }
        MusicController.Instance.stopSound("", SoundCategory.MUSIC);
        MusicController.Instance.stopSound("", SoundCategory.AMBIENT);
        Client.sendData(EnumPacketServer.JobSave, this.job.save(new NBTTagCompound()));
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        GuiSoundSelection gss = (GuiSoundSelection)subgui;
        if (gss.selectedResource != null) {
            this.job.song = gss.selectedResource.toString();
        }
        this.func_73866_w_();
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        switch (textField.getID()) {
            case 1: {
                this.job.song = textField.getFullText();
                break;
            }
            case 2: {
                if (this.job.isRange) {
                    this.job.range[0] = textField.getInteger();
                    break;
                }
                this.job.minPos[0] = textField.getInteger();
                break;
            }
            case 3: {
                this.job.minPos[1] = textField.getInteger();
                break;
            }
            case 4: {
                this.job.minPos[2] = textField.getInteger();
                break;
            }
            case 5: {
                if (this.job.isRange) {
                    this.job.range[1] = textField.getInteger();
                    break;
                }
                this.job.maxPos[0] = textField.getInteger();
                break;
            }
            case 6: {
                this.job.maxPos[1] = textField.getInteger();
                break;
            }
            case 7: {
                this.job.maxPos[2] = textField.getInteger();
            }
        }
    }
}

